<?php include('common/header.php'); ?>

<?php
require_once "common/Queries.php";
$q = new Queries();

/* ----------------------------------------------------------
   HELPERS
---------------------------------------------------------- */
function firstCategoryWithPackages(Queries $q, int $mainCatId): ?int {
    $subs = $q->getSubCategories($mainCatId);
    if (!$subs) return null;

    foreach ($subs as $sub) {
        if ($q->getPackagesByCategory($sub["id"])) {
            return (int)$sub["id"];
        }
        foreach ($q->getSubCategories($sub["id"]) as $child) {
            if ($q->getPackagesByCategory($child["id"])) {
                return (int)$child["id"];
            }
        }
    }
    return null;
}

/* ----------------------------------------------------------
   MAIN / SUB / CURRENT CATEGORY SELECTION
---------------------------------------------------------- */

$mainCatId    = $_GET["main"] ?? null;
$currentCatId = $_GET["id"]   ?? null;

$mainCategories = $q->getMainCategories();
if (!$mainCatId) $mainCatId = $mainCategories[0]["id"];

$subCategories = $q->getSubCategories($mainCatId);

// if NO category selected → find first category that has packages
if (!$currentCatId) {
    $currentCatId = firstCategoryWithPackages($q, $mainCatId);
}

// Get current category
$currentCategory = $q->getCategory($currentCatId);
$currentTitle = $currentCategory['name'] ?? "Services";

// Load packages for selected category
$packages = $q->getPackagesByCategory($currentCatId);

?>

<!-- TOP BANNER -->
<section class="banner-inner m-3">
  <div class="overlay position-absolute start-0 bottom-0 end-0 pb-5 mb-5 text-white z-3">
    <div class="container">
      <div class="d-flex">
        <div class="flex-grow-1">
          <div class="display-4 fw-bolder">Our Services</div>
        </div>
        <div class="flex-fixed">
          <div class="d-flex flex-column">
            <p>How can we help?</p>
            <div class="d-flex rounded align-items-center bg-white px-3 search py-1">
              <i class="ri-search-line h4 m-0 text-secondary"></i>
              <input type="search" class="form-control w-100 border-0" placeholder="Find Products ">
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <img src="images/banner-service.jpg" class="object-fit-cover img-fluid d-block">
</section>


<div class="content-wraper">

  <!-- ✅ MAIN CATEGORY SELECTOR -->
  <div class="pb-4">
    <?php include("common/service-selector.php"); ?>
  </div>


  <div class="container">
    <div class="d-lg-flex align-items-start service-wraper">

      <!-- ✅ LEFT SIDEBAR -->
      <div class="service-nav open flex-shrink-0">
        <div class="nav-hed d-flex justify-content-between m-3">
          <h6 class="m-0 fw-bold">Select Categories</h6>
          <button class="togler p-0 border-0 bg-transparent" id="navToggler">
            <div class="span-1"></div>
            <div class="span-2"></div>
          </button>
        </div>

        <div class="service-nav-content" data-simplebar>
          <div class="accordion" id="accordionExample">

            <?php foreach ($subCategories as $sub): ?>
              <?php
                $childCategories = $q->getSubCategories($sub["id"]);
                $isParent = ($currentCategory && $currentCategory["parent"] == $sub["id"]);
                $open = ($currentCatId == $sub["id"] || $isParent) ? "show" : "";
                $collapsed = $open ? "" : "collapsed";
              ?>
              <div class="accordion-item">
                <h2 class="accordion-header">
                  <button class="accordion-button <?= $collapsed ?>" data-bs-toggle="collapse"
                          data-bs-target="#collapse<?= $sub["id"] ?>">
                    <?= $sub["name"] ?>
                  </button>
                </h2>

                <div id="collapse<?= $sub['id'] ?>" class="accordion-collapse collapse <?= $open ?>">
                  <div class="accordion-body">
                    <ul class="sub-nav">
                      <?php foreach ($childCategories as $child): ?>
                        <li>
                          <a href="services.php?main=<?= $mainCatId ?>&id=<?= $child["id"] ?>"
                             class="<?= ($currentCatId == $child["id"]) ? 'active' : '' ?>">
                            <?= $child["name"] ?>
                          </a>
                        </li>
                      <?php endforeach; ?>
                    </ul>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
        </div>
      </div>

      <!-- ✅ RIGHT SIDE PACKAGE SLIDER -->
      <div class="flex-grow-1 min-vw-0 pt-4 pt-lg-0 ps-4">

        <div class="pb-4 pb-lg-5">
          <div class="display-6 fw-bolder"><?= $currentTitle ?></div>
          Select your desired resource to see the pricing
        </div>

        <?php if ($packages): ?>
          <div class="service-slider">
            <div class="swiper swiper-news max-w-100">
              <div class="swiper-wrapper">

                <?php foreach ($packages as $i => $pkg): ?>
                  <div class="swiper-slide">
                    <div class="service-item recomended">

                      <div class="position-absolute end-0 top-0 pt-3 pe-3">
                        <input type="checkbox"
                               class="custom-check package-selector"
                               data-package-id="<?= $pkg['id'] ?>"
                               <?= ($i == 0 ? "checked" : "") ?>>
                      </div>

                      <div class="inner p-4 position-relative">
                        <div class="pt-5 text-center">
                          <div class="h2 fw-bolder"><?= $pkg["name"] ?></div>
                          <p><?= $pkg["subtitle"] ?></p>

                          <div class="d-flex align-items-center justify-content-center gap-1 pb-3">
                            <span class="fs-5 fw-bolder"><?= $pkg["special_price"] ?> <?= $pkg["currency"] ?></span> / month
                            <div class="text-black"><del><?= $pkg["price"] ?> <?= $pkg["currency"] ?></del></div>
                          </div>

                          <a href="<?= $pkg["url"] ?>" class="btn btn-dark w-100">Order Now</a>
                          <?= $pkg["description"] ?>
                        </div>
                      </div>

                    </div>
                  </div>
                <?php endforeach; ?>

              </div>
            </div>
          </div>
        <?php endif; ?>

      </div>

    </div>
  </div>


  <!-- ✅ FEATURES SECTION (AJAX LOADED INTO THIS CONTAINER) -->
  <section id="dynamic-features" class="pt-5 pt-lg-6 pt-xl-7"></section>

</div>




<?php include('common/footer.php'); ?>
