<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;

/* @var $this yii\web\View */
/* @var $model common\models\Files */
/* @var $form yii\widgets\ActiveForm */
$this->title = Yii::t('app', 'Management');
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>

                    <?= $form->field($model, 'title')->textInput() ?>
                    <?= $form->field($model, 'position')->textInput() ?>
                    <?= $form->field($model, 'phone')->textInput() ?>
                    <?= $form->field($model, 'email')->textInput() ?>

                    <?= $form->field($model, 'file_name')->fileInput()->label(); ?>
                    <?php if(!$model->isNewRecord):
                        echo Html::img(Yii::$app->urlManagerfrontend->baseUrl.'/uploads/'.$model->file_name,['class' => 'img-responsive img-thumbnail','width'=>100]) ;
                        echo Html::activeHiddenInput($model, 'file_name');
                    endif;
                    ?>

                    <?= $form->field($model, 'sort_order')->textInput() ?>

                    <div class="form-group">
                        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Add') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>

                <div class="box-body pad">
                    <div class="row">
                        <?php
                        if($managements){
                            foreach($managements as $banner){
                                ?>
                                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                                    <a class="thumbnail" href="#">
                                        <img class="img-responsive" src="<?php echo Yii::$app->urlManagerfrontend->baseUrl.'/uploads/'.$banner->file_name?>" alt="">
                                    </a>
                                    <div class="text-center">
                                        <?= Html::a('<i class="fa fa-pencil"></i>', ['settings/management','id'=>$banner->file_id], [
                                            'class'=>'btn btn-danger btn-xs',

                                        ]) ?>
                                        <?= Html::a('<i class="fa fa-trash-o"></i>', ['settings/deleteimage', 'id' =>$banner->file_id], [
                                            'class'=>'btn btn-danger btn-xs',
                                            'data' => [
                                                'confirm' => 'Are you sure you want to delete this image?',
                                                'method' => 'post',
                                            ],
                                        ]) ?>
                                    </div>
                                </div>
                            <?php }}?>
                    </div>
                </div>
                <!-- /.box -->

            </div>
        </div>
</section>

