<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\Participants2025Search */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Participants';
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="box-body pad">
                    <?php echo $this->render('_search', ['model' => $searchModel]); ?>
                </div>
                <div class="box-body pad">

                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        //'filterModel'  => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            'id',
                            'name',
                            'email:email',
                            'uuid',
                            'contact',
                            'country',

                           /* [
                                'attribute' => 'prizes',
                                'format' => 'ntext',
                            ],*/

                            // Purchase receipt link
                            [
                                'attribute' => 'purchase_receipt',
                                'format' => 'raw',
                                'value' => function ($model) {
                                    return $model->purchase_receipt
                                        ? Html::a('View Receipt', $model->purchase_receipt, [
                                            'target' => '_blank',
                                            'class' => 'btn btn-xs btn-info'
                                        ])
                                        : '-';
                                },
                            ],

                            'user_language',
                            'date_time',
                          //  'source_sheet',

                           /* [
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{view} {update}',
                                'buttons' => [
                                    'view' => function ($url, $model, $key) {
                                        return Html::a('View', $url, ['class' => 'btn btn-primary btn-xs']);
                                    },
                                    'update' => function ($url, $model, $key) {
                                        return Html::a('Update', $url, ['class' => 'btn btn-warning btn-xs']);
                                    },
                                ],
                            ],*/
                        ],
                    ]); ?>

                </div>
            </div>
        </div>
    </div>
</section>
