<?php

namespace frontend\controllers;

use common\models\Participants2021;
use common\models\Settingstwo;
use common\models\Settings;
use common\models\Prizes;
use common\models\Winner2021;
use common\models\Participants2025;

use yii\web\UploadedFile;
use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

/**
 * Site controller
 */
class SiteController extends Controller
{
    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [

            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    // 'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    public function actionTest()
    {
        /* $participants = Participants2025::find()
        ->orderBy([new Expression("CASE WHEN quantity REGEXP '^[0-9]+$' THEN 0 ELSE 1 END, quantity+0 DESC")])
        //->addOrderBy(new Expression('rand()'))
        ->select(['name', 'mobile', 'quantity', 'receipt_image', 'id'])
        ->where(['status' => 'Approved', 'winner' => 0])
        ->limit(50)
        ->distinct()
        ->all();
        print_r($participants);exit;*/
    }

   

    public function actionIndex()
    {
        $prizes = Settings::findOne(24);
        $participants = Participants2025::find()
            ->addOrderBy(new Expression('rand()'))
            ->groupBy(['contact', 'email'])
            ->where(['winner' => 0])
            ->distinct()
            ->all();
            
        $type = Settings::find()->where(['type' => 'option'])->one();
        $modelTime = Settingstwo::find()->where(['type' => 'time'])->one();
        $modelTitle = Settings::find()->where(['item' => 'prize'])->one();

        $list = [];

        foreach ($participants as $participant) {
            $winnerornot = Winner2021::find()->where(['fk_parcipant_id' => $participant->id])->one();
 print_r($winnerornot);exit;
            if ($winnerornot) {
               
                if ($winnerornot->user) {
                    if (cleanPhoneNumber($winnerornot->user->contact) != cleanPhoneNumber($participant->contact)) {
                        $list[] = $participant->name . ' - ' . cleanPhoneNumber($participant->contact) . '<span style="display:none">|' . $participant->id . '</span>';
                    }
                }
            } else {
                $list[] = $participant->name . ' - ' . cleanPhoneNumber($participant->contact) . '<span style="display:none">|' . $participant->id . '</span>';
                print_r($list);exit;
            }
        }

        return $this->render('index', [
            'prizes' => $prizes,
            'list' => json_encode($list, JSON_UNESCAPED_UNICODE),
            'type' => $type,
            'modelTime' => $modelTime->value,
            'modelTitle' => $modelTitle,
        ]);
    }
    
    function cleanPhoneNumber($phone)
    {
        return str_replace(['+', "'"], '', $phone);
    }


    public function actionUpdate_file($id)
    {

        if (isset($_POST['text'])) {
            list($val, $userid) = explode('|', $_POST['text']);
            $value = $val;
            $participant = Participants2025::findOne($userid);
            $prize = Settings::findOne(24);
            $participant->winner = 1;
            $participant->save(false);
            $model = new Winner2021;
            $model->fk_parcipant_id = $userid;
            $model->details = $prize->title;
            $model->prize_date = date('Y-m-d');
            $model->save(false);

            $prize->value = $prize->value - 1;
            $prize->type = $prize->type + 1;
            $prize->save(false);
             $participants = Participants2025::find()
            ->addOrderBy(new Expression('rand()'))
            ->groupBy(['contact', 'email'])
            ->where(['winner' => 0])
            ->distinct()
            ->all();

            $list = [];
            
            foreach ($participants as $participant) {
            $winnerornot = Winner2021::find()->where(['fk_parcipant_id' => $participant->id])->one();

            if ($winnerornot) {
                if ($winnerornot->user) {
                    if (cleanPhoneNumber($winnerornot->user->contact) != cleanPhoneNumber($participant->contact)) {
                        $list[] = $participant->name . ' - ' . cleanPhoneNumber($participant->contact) . '<span style="display:none">|' . $participant->id . '</span>';
                    }
                }
            } else {
                $list[] = $participant->name . ' - ' . cleanPhoneNumber($participant->contact) . '<span style="display:none">|' . $participant->id . '</span>';
            }
        }
            $res = ['winner' => $prize->type, 'avilable' => $prize->value, 'list' => $list];
            echo  json_encode($res, JSON_UNESCAPED_UNICODE);
            exit;
        }
    }

    public function actionViewWinners()
    {
        $winners = Winner2021::find()->where(['prize_date' => date('Y-m-d')])->all();

        return $this->render('winners', [
            'winners' => $winners,
        ]);
    }


}
