<?php
require_once "Database.php";

class Queries {

    private $db;

    public function __construct()
    {
        $this->db = Database::connect();
    }

    public function imageServerPath()
    {
        return 'https://ca.adventzeventz.com';
    }

    public function getBanners()
    {
        return $this->db->select("banner", "*", [
            "deleted_at" => null,
            "ORDER" => ["sort_order" => "ASC"]
        ]);
    }

    public function getModule($type)
    {
        return $this->db->get("modulecontents", "*", [
            "type" => $type
        ]);
    }

    public function getHomeProducts()
    {
        return $this->db->select("griditems", "*", [
            "type" =>'Productsindex',
            "deleted_at" => null,
            "ORDER" => ["sort" => "ASC"]
        ]);
    }

    public function getNews()
    {
        return $this->db->select("news", "*", [
            "deleted_at" => null,
            "ORDER"      => ["created_at" => "DESC"],
            "LIMIT"      => 3
        ]);
    }

    public function getMainCategories()
    {
        return $this->db->select("categories", "*", [
            "parent" => 0,
            "deleted_at" => null,
            "status" => "1",
            "ORDER" => ["sort_order" => "ASC"]
        ]);
    }

    public function getSubCategories($parent)
    {
        return $this->db->select("categories", "*", [
            "parent" => $parent,
            "deleted_at" => null,
            "status" => "1",
            "ORDER" => ["sort_order" => "ASC"]
        ]);
    }

    public function getCategory($id)
    {
        return $this->db->get("categories", "*", [
            "id" => $id,
            "deleted_at" => null
        ]);
    }

    /* ✅ Load packages dynamically */
    public function getPackagesByCategory($categoryId)
    {
        return $this->db->select("packages", "*", [
            "category_id" => $categoryId,
            "deleted_at"  => null,
            "status"      => 1,
            "ORDER"       => ["sort_order" => "ASC"]
        ]);
    }

    public function getFeaturesTilte($id)
    {
        return $this->db->get("modulecontents", "*", [
            "type" => $id,
            "deleted_at" => null
        ]);
    }

    public function getModuleByPackage($packageId)
    {
        return $this->db->get("modulecontents", "*", [
            "type" => $packageId,
            "deleted_at" => null
        ]);
    }

    public function getFeaturesByPackage($packageId)
    {
        return $this->db->select("griditems", "*", [
            "package_id" => $packageId,
            "deleted_at" => null,
            "ORDER" => ["sort" => "ASC"]
        ]);
    }

}
