// service-nav


// Smooth Scroll

const lenis = new Lenis();
lenis.on("scroll", (e) => {
  console.log(e);
});
function raf(time) {
  lenis.raf(time);
  requestAnimationFrame(raf);
}
requestAnimationFrame(raf);

// Preloader
window.addEventListener("load", function () {
  setTimeout(function () {
    var loaderOverlay = document.querySelector(".loader-overlay");
    loaderOverlay.style.transition = "opacity 0.5s";
    loaderOverlay.style.opacity = "0";

    setTimeout(function () {
      loaderOverlay.style.display = "none";
      swiperSlider.autoplay.start();
    }, 500); // Adjust the time for display:none to match your transition time
  }, 2000); // Adjust the initial delay time
});

// Navbar fixed on scroll
window.addEventListener("scroll", function () {
  var sticky = document.querySelector("header");
  var scroll = window.pageYOffset || document.documentElement.scrollTop;

  if (scroll >= 10) {
    sticky.classList.add("navbar-fixed");
  } else {
    sticky.classList.remove("navbar-fixed");
  }
});

// Scroll to top----------------

// Get the return-top button element
var returnTopButton = document.getElementById("return-top");

// Function to handle the scroll event
function handleScroll() {
  if (window.scrollY >= 50) {
    // If page is scrolled more than 50px
    returnTopButton.style.opacity = "1"; // Fade in the arrow
  } else {
    returnTopButton.style.opacity = "0"; // Else fade out the arrow
  }
}

// Add a scroll event listener to the window
window.addEventListener("scroll", handleScroll);

// Function to scroll to the top when the button is clicked
function scrollToTop() {
  // When arrow is clicked
  window.scrollTo({
    top: 0, // Scroll to the top of the page
    behavior: "smooth", // Smooth scrolling behavior
  });
}

// Add a click event listener to the return-top button
returnTopButton.addEventListener("click", scrollToTop);

// Initialize the Banner Swiper slider
const swiperHero = new Swiper(".swiper-hero", {
  // Optional parameters
  loop: true,
  speed: 1500,
  effect: "slide",
  autoplay: {
    delay: 3000,
    disableOnInteraction: false,
  },
  // If we need pagination
  pagination: {
    el: ".swiper-pagination",
    clickable: true,
  },
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
});

// Testimonial Slider
const sliderTesti = new Swiper(".swiper-testi", {
  loop: true,
  speed: 1500,
  effect: "slide",
  autoplay: {
    delay: 2500,
    disableOnInteraction: false,
  },
  spaceBetween: 20,
  slidesPerView: "auto",
  navigation: {
    nextEl: ".testi-swiper-button-next",
    prevEl: ".testi-swiper-button-prev",
  },
});

// News Slider
const sliderNews = new Swiper(".swiper-news", {
  loop: true,
  speed: 1500,
  effect: "slide",
  autoplay: {
    delay: 2500,
    disableOnInteraction: false,
  },
  spaceBetween: 10,
  breakpoints: {
    480: {
      slidesPerView: 1,
    },
    768: {
      slidesPerView: 2,
    },
    1200: {
      slidesPerView: 3,
    },
  },
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
});
// service slider
const serviceSwiper = new Swiper(".swiper-service", {
    loop: true,
    spaceBetween: 10, 
    navigation: {
      nextEl: ".service-swiper-button-next",
      prevEl: ".service-swiper-button-prev",
    },
    breakpoints: {
      0: {         // mobile
        slidesPerView: 1,
      },
      768: {       // tablet
        slidesPerView: 2,
      },
      1200: {      // desktop
        slidesPerView: 3,
      }
    }
  });

  const toggler = document.getElementById("navToggler");
const serviceNav = document.querySelector(".service-nav");

// make sure it's open by default
serviceNav.classList.add("open");

toggler.addEventListener("click", () => {
  if (serviceNav.classList.contains("open")) {
    // close it
    serviceNav.classList.remove("open");
    serviceNav.classList.add("closed");
  } else {
    // open it
    serviceNav.classList.remove("closed");
    serviceNav.classList.add("open");
  }
});