<?php

namespace backend\controllers;

use backend\models\Import;
use common\models\Branches;
use common\models\Participants2020;
use Yii;
use common\models\Participants;
use common\models\ParticipantsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;

/**
 * ParticipantsController implements the CRUD actions for Participants model.
 */
class ParticipantsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Participants models.
     * @return mixed
     */
    public function actionIndex($id)
    {
        $searchModel = new ParticipantsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams,$id);

        $branches=Branches::find()->where(['id'=>$id])->one();

        $import=new Import();

        if ($import->load(Yii::$app->request->post())) {
            ini_set('memory_limit','500M');
            $rand_name = rand(10045,9999955);
            $path = Yii::getAlias('@webroot') .'/uploads/';

            $uploadedFile = UploadedFile::getInstance($import,'excel_file');

            if ($uploadedFile){
                $import->excel_file = "{$rand_name}-{$uploadedFile}";
            }

            if ($uploadedFile) {
                $uploadedFile->saveAs($path.$import->excel_file);
                $data = \moonland\phpexcel\Excel::widget([
                    'mode' => 'import',
                    'fileName' => $path.$import->excel_file,
                    'setFirstRecordAsKeys' => true, // if you want to set the keys of record column with first record, if it not set, the header with use the alphabet column on excel.
                    'setIndexSheetByName' => true, // set this if your excel data with multiple worksheet, the index of array will be set with the sheet name. If this not set, the index will use numeric.
                    'getOnlySheet' => 'sheet1', // you can set this property if you want to get the specified sheet from the excel data with multiple worksheet.
                ]);

                foreach($data as $item){
                    $participant=new Participants2020();
                    $participant->name=$item['name'];
                    $participant->mobile=$item['mobile'];
                    $participant->chassis_number=$item['chassis_number'];
                    $participant->fk_branch_id=$id;
                    $participant->save(false);
                }

            }
            return $this->redirect(['index']);
        }

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'import' => $import,
            'branches' => $branches,
        ]);
    }

    /**
     * Displays a single Participants model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Participants model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Participants();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Participants model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Participants model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
       $model= $this->findModel($id);
       $id=$model->fk_branch_id;

        return $this->redirect(['index','id'=>$id]);
    }
    public function actionDeleteall()
    {
        Participants::deleteAll();
        return $this->redirect(['index']);
    }

    /**
     * Finds the Participants model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Participants the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Participants::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
