<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;
use dosamigos\fileupload\FileUploadUI;
use yii\widgets\Pjax;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model common\models\Cms */
/* @var $form yii\widgets\ActiveForm */
$this->title = 'Category';
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                    <div class="pull-right box-tools">


                    </div>
                </div>
                <!-- /.box-header -->

                <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                <div class="box-body">

                    <div class="col-md-6">

                        <?= $form->field($model, 'title')->textInput()?>

                        <?= $form->field($model, 'sort_order')->textInput()?>
                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Add') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success btn-block' : 'btn btn-primary  btn-block']) ?>
                        </div>
                    </div>
                </div>
                <?php ActiveForm::end(); ?>
                <div class="box-body">

                    <table class="kv-grid-table table table-hover table-bordered kv-table-wrap">
                        <thead>
                        <tr>
                            <th>Category Name</th>

                            <th>Sort Order</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        if($provider->getModels()){
                         foreach($provider->getModels() as $parent){
                        ?>
                        <tr>
                            <td><b><?=$parent->title?></b></td>

                            <td><?=$parent->sort_order?></td>
                            <td>
                                <?=
                                Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['/settings/category','id'=>$parent->category_id], ['title' => 'edit']);
                               Html::a('<span class="glyphicon glyphicon-trash"></span>', ['/settings/categorydelete', 'id' => $parent->category_id], [
                                    'class' => '',
                                ])?>
                            </td>
                        </tr>

                        <?php } }?>


                        </tbody>
                    </table>

                </div>

            </div>
        </div>
    </div>
</section>
