<?php

use yii\helpers\Html;
use yii\grid\GridView;
use kartik\export\ExportMenu;
/* @var $this yii\web\View */
/* @var $searchModel common\models\Winner2021Search */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Winners';
$this->params['breadcrumbs'][] = $this->title;
?>

    <section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Winners</h3>
                    <div class="pull-right box-tools">
                        <?php //echo Html::a('Delete All ', ['deleteall'], ['class' => 'btn btn-danger']) ?>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                <?php //echo $this->render('_search', ['model' => $searchModel]); ?>
                    <hr>

                    <?php
                        $gridColumns = [
                            ['class' => 'yii\grid\SerialColumn'],
                            [
                                'label'=>'Promotor Name',
                                'value'=>function ($model, $key, $index, $widget) {
                                  return $model->user->promoters->name;
                                },
                                'format'=>'html'
                            ],
                            'user.consumer_name',
                            'user.civil_id',
                            'user.mobile',
                            'user.web_reference',
                            'details:ntext',
                            [
                                'label'=>'Invoice',
                                'value'=>function ($model, $key, $index, $widget) {
                                    $url= Yii::$app->urlManagerfrontend->createAbsoluteUrl('/uploads/'.$model->user->invoice);
                                    return $url;
                                },
                                'format'=>'html'
                            ],
                            
                            'prize_date',
                        ];?>
                        <?= ExportMenu::widget([
                            'dataProvider' => $dataProvider,
                            'columns' => $gridColumns,
                            'target' => ExportMenu::TARGET_BLANK,
                            'columnSelectorOptions'=>[
                                'label' => 'Columns',
                            ],
                            'fontAwesome' => true,
                            'dropdownOptions' => [
                                'label' => 'Export To Excel',
                            ],
                            'exportConfig' => [
                                ExportMenu::FORMAT_TEXT => false,
                                ExportMenu::FORMAT_PDF => false,
                                ExportMenu::FORMAT_CSV => false,
                                ExportMenu::FORMAT_HTML => false,
                                ExportMenu::FORMAT_EXCEL=>false,
                            ]
                        ]); ?>

                <?= GridView::widget([
                    'dataProvider' => $dataProvider,
                  //  'filterModel' => $searchModel,
                    'columns' => [
                        ['class' => 'yii\grid\SerialColumn'],
                        [
                            'label'=>'Promotor Name',
                            'value'=>function ($model, $key, $index, $widget) {
                              return  $model->user->promoters ? $model->user->promoters->name :'';
                            },
                            'format'=>'html'
                        ],
                        'user.consumer_name',
                        'user.civil_id',
                        'user.mobile',
                        'user.web_reference',
                        'details:ntext',
                        [
                            'label'=>'Invoice',
                            'value'=>function ($model, $key, $index, $widget) {
                                $url= Yii::$app->urlManagerfrontend->createAbsoluteUrl('/uploads/'.$model->user->invoice);
                                return '<a href="'.$url.'" >View</a>';
                            },
                            'format'=>'html'
                        ],
                        
                        'prize_date',

                        //['class' => 'yii\grid\ActionColumn'],
                    ],
                ]); ?>
            </div>
        </div>
    </div>
</section>


