<?php
namespace frontend\controllers;
use common\models\Participants2021;
use common\models\Settingstwo;
use common\models\Settings;
use common\models\Prizes;
use common\models\Winner2021;
use common\models\Consumers;

use yii\web\UploadedFile;
use Yii;
use yii\base\InvalidParamException;
use yii\web\BadRequestHttpException;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
use common\models\LoginForm;
use frontend\models\PasswordResetRequestForm;
use frontend\models\ResetPasswordForm;
use yii\web\NotFoundHttpException;
use yii\data\ActiveDataProvider;
use yii\helpers\ArrayHelper;
use yii\db\Expression;

/**
 * Site controller
 */
class SiteController extends Controller
{
    public $enableCsrfValidation = false;

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [

            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                   // 'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

   

    public function actionAddConsumer()
    {
       $this->layout='mainnew';

       if(isset($_POST['name'])){
        $name=strip_tags($_POST['name']);
        $email=strip_tags($_POST['email']);
        $mobile=strip_tags($_POST['mobile']);
        $couponnumber=strip_tags($_POST['couponnumber']);

        $couponcheck=Consumers::find()->where(['invoice_number'=>$couponnumber])->one();
        if($couponcheck){
            Yii::$app->session->setFlash('error', 'This coupon number already exist!');
            return $this->redirect(['add-consumer']);
        }

        $couponFile = $_FILES['couponimage']['name'];
        if (empty($name) || empty( $email) || empty($mobile)||empty($couponnumber)) {
            Yii::$app->session->setFlash('error', 'Required Fields were left empty. Please try again!');
            return $this->redirect(['add-consumer']);
        }else{
            $model=new Consumers();
            $rand_name = rand(10045, 9999955);
            $path = Yii::getAlias('@frontend') . '/web/uploads/';
            $model->created_date = date('Y-m-d');
            $today = date('YmdHi');
            $startDate = date('YmdHi', strtotime('2022-03-14 09:06:00'));
            $range = $today - $startDate;
            $rand = rand(0, $range);
            $model->web_reference =$rand;
            $model->consumer_name=$name;
            $model->invoice_number=$couponnumber;
            $model->mobile=$mobile;
            $model->email=$email;
            $model->status=0;
            $couponFile = explode(".", $couponFile);
            $model->invoice = $rand_name.round(microtime(true)) .'_coupon_copy_'.reset($couponFile).'.' . end($couponFile);
            $fileTmpNameCoupon  = $_FILES['couponimage']['tmp_name'];
            if( $model->save(false)){
                move_uploaded_file($fileTmpNameCoupon, $path.$model->invoice);
                Yii::$app->session->setFlash('success', 'Thank you, your entry has been submitted. You will receive an email confirmation once it accepted. Please check your spam folder also.');
                return $this->redirect(['add-consumer']);
            }
          
        }
       }
        
      
        return $this->render('add_consumer', [
        ]);

    }

    public function actionLogin()
    {
        // return $this->redirect(['registration-closed']);
        if(!Yii::$app->user->isGuest){
            return $this->redirect(['add-consumer']);
        }
        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->redirect(['add-consumer']);
        } else {
            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }
    
    public function actionRegistrationClosed()
    {
        return $this->render('closed', [
           
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->redirect(['login']);
    }

    public function actionIndex()
    {
        $prizes=Settings::findOne(24);
        $participants=Consumers::find()->orderBy(new Expression('rand()'))->select(['consumer_name','mobile','civil_id','id'])->distinct()->all();

        $type=Settings::find()->where(['type'=>'option'])->one();
        $modelTime=Settingstwo::find()->where(['type'=>'time'])->one();

        $list=[];

        foreach ($participants as $participant){
            
            $list[]=$participant->consumer_name.' - '.$participant->mobile.' - '.$participant->civil_id.'<span style="display:none">|'.$participant->id.'</span>';
        }

   
        
        return $this->render('index', [
            'prizes'=>$prizes,
            'list'=>json_encode($list,JSON_UNESCAPED_UNICODE),
            'type'=>$type,
            'modelTime'=>$modelTime->value
        ]);
    }

    public function actionLuckyDraw($id)
    {
        $model=Prizes::find()->where(['id'=>Yii::$app->basic->simple_crypt($id,'d')])->one();
        if (!$model) {
            throw new NotFoundHttpException('The requested page does not exist.');
        }

        $participants=Participants2021::find()->orderBy(new Expression('rand()'))->select(['name','mobile','chassis_number','id'])->distinct()->where('winner<>1')->all();
      
        $type=Settings::find()->where(['type'=>'option'])->one();
        $modelTime=Settingstwo::find()->where(['type'=>'time'])->one();

        $list=[];

        foreach ($participants as $participant){
            
            $list[]=$participant->name.' - '.$participant->mobile.' - '.$participant->location.'<span style="display:none">|'.$participant->id.'</span>';
        }

        $towrite= json_encode($list,JSON_UNESCAPED_UNICODE);

        $title=$model->name.'('.time().").txt";
        $myfile = fopen($title,"w");

        $session = Yii::$app->session;
        $session->set('file_name',$title);
        $branchname = "Branch Name :-".$model->name.PHP_EOL;
        fwrite($myfile, $branchname);
        $txt = "Date and time :-".date('Y/m/d H:m:s').PHP_EOL;
        fwrite($myfile, $txt);

        $txt = $towrite;
        fwrite($myfile, $txt);
        fclose($myfile);

        return $this->render('lucky-draw', [
            'model'=>$model,
            'list'=>json_encode($list,JSON_UNESCAPED_UNICODE),
            'type'=>$type,
            'modelTime'=>$modelTime->value
        ]);
    }
    public function actionLuckyDrawMultiple($id)
    {
        $model=Prizes::find()->where(['id'=>Yii::$app->basic->simple_crypt($id,'d')])->one();
        if (!$model) {
            throw new NotFoundHttpException('The requested page does not exist.');
        }

        $participants=Participants2021::find()->orderBy(new Expression('rand()'))->select(['name','mobile','chassis_number','id'])->distinct()->where('winner<>1')->all();
        $type=Settings::find()->where(['type'=>'option'])->one();
        $modelTime=Settingstwo::find()->where(['type'=>'time'])->one();

        $list=[];

        foreach ($participants as $participant){
            
            $list[]=$participant->name.' - '.$participant->mobile.' - '.$participant->chassis_number.'<span style="display:none">|'.$participant->id.'</span>';
        }

        $towrite= json_encode($list,JSON_UNESCAPED_UNICODE);

        $title=$model->name.'('.time().").txt";
        $myfile = fopen($title,"w");

        $session = Yii::$app->session;
        $session->set('file_name',$title);
        $branchname = "Branch Name :-".$model->name.PHP_EOL;
        fwrite($myfile, $branchname);
        $txt = "Date and time :-".date('Y/m/d H:m:s').PHP_EOL;
        fwrite($myfile, $txt);

        $txt = $towrite;
        fwrite($myfile, $txt);
        fclose($myfile);

        return $this->render('lucky-draw-multiple', [
            'model'=>$model,
            'list'=>json_encode($list,JSON_UNESCAPED_UNICODE),
            'type'=>$type,
            'modelTime'=>$modelTime->value
        ]);
    }

    public function actionWinners($id)
    {
        $session = Yii::$app->session;
        if(isset($_SESSION['winners']) ){
            $session->remove('winners');
        }
        
        $prize=Prizes::findOne($id);
        $winners=Participants2021::find()->orderBy(new Expression('rand()'))->select(['name','mobile','chassis_number','id'])->distinct()->andWhere('winner<>1')->limit($prize->quantity)->all();
        $session = Yii::$app->session;
        $session->set('winners',$winners);
        foreach($winners as $winner){
            $participant=Participants2021::findOne($winner->id);
            $participant->winner=1;
            $participant->save(false);
            $model=new Winner2021;
            $model->fk_parcipant_id=$winner->id;
            $model->fk_prize_id=$id;
            $model->details=$winner->name.' - '.$winner->mobile.' - '.$winner->chassis_number;
            $model->prize_date=date('Y-m-d');
            $model->save(false);
            
        }
        $prize->current_qty=0;
        $prize->save(false);

        return $this->render('winners', [
            'prize'=>$prize,
            'winners'=>$winners,
        ]);
    }

    public function actionUpdate_file($id)
    {
       
            if(isset($_POST['text'])){
                list($val, $userid)=explode('|', $_POST['text']);
                $value=$val;
               /* $handle = fopen($_POST['text'], 'a');
                $txt = "Winner:-".$value.PHP_EOL;
                $dbwinner = $value.PHP_EOL;
                fwrite($handle, $txt);
                $txtDate = "Winner Date:-".date('Y/m/d H:m:s').PHP_EOL;
                $dbDate = date('Y/m/d H:m:s').PHP_EOL;
                fwrite($handle, $txtDate);
                fclose($handle);*/
 
                $participant=Consumers::findOne($userid);
                $participant->winner=1;
                $participant->save(false);
                $model=new Winner2021;
                $model->fk_parcipant_id=$userid;
                $model->fk_prize_id=$id;
                $model->details=$value;
                $model->prize_date=date('Y-m-d');
                $model->save(false);
                $prize=Settings::findOne(24);
                $prize->value=$prize->value-1;
                $prize->type=$prize->type+1;
                $prize->save(false);
                $res=['winner'=> $prize->type,'avilable'=>$prize->value];
                echo  json_encode($res); exit;
            }
    }

    public function actionFinish($id)
    {
        $model=Prizes::findOne($id);
        $model->draw_status=0;
        $model->save();
        echo 'success';exit;
    }

    public function actionFinishMultiple($id)
    {
        $model=Prizes::findOne($id);
        $model->draw_status=0;
        $model->save(false);
        return $this->redirect(['index']);
    }


}
