<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "winner_2021".
 *
 * @property int $id
 * @property int $fk_parcipant_id
 * @property int $fk_prize_id
 * @property string $details
 * @property string $prize_date
 */
class Winner2021 extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'winner_2021';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fk_parcipant_id', 'fk_prize_id'], 'integer'],
            [['details'], 'string'],
            [['prize_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fk_parcipant_id' => 'Fk Parcipant ID',
            'fk_prize_id' => 'Prize',
            'details' => 'Winner Details',
            'prize_date' => 'Prize Date',
        ];
    }


    public function getUser()
    {
        return $this->hasOne(Consumers::className(), ['id' => 'fk_parcipant_id']);
    }

    
}
