<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\export\ExportMenu;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $searchModel common\models\BranchesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Branches';
$this->params['breadcrumbs'][] = $this->title;
?>
<section class="content">
    <div class="row">
        <!-- left column -->

        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>

                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                    <?php
                    $gridColumns = [
                        ['class' => 'kartik\grid\SerialColumn'],

                        'branch_name',

                        [
                            'label'=>'Winner(Name-Mobile-Chassis Number)',
                            'format'=>'raw',
                            'value' => function($data){
                                return $data->winner;
                            }
                        ],

                        [
                            'label'=>'Date',
                            'format'=>'raw',
                            'value' => function($data){
                                return $data->winner_date;
                            }
                        ],
                    ];

                    echo  ExportMenu::widget([
                        'dataProvider' => $dataProvider,
                        'columns' => $gridColumns,
                        'target' => ExportMenu::TARGET_BLANK,
                        'columnSelectorOptions'=>[
                            'label' => 'Columns',

                        ],
                        'fontAwesome' => true,
                        'dropdownOptions' => [
                            'label' => 'Export To Excel',

                        ],
                        'exportConfig' => [
                            ExportMenu::FORMAT_TEXT => false,
                            ExportMenu::FORMAT_PDF => false,
                            ExportMenu::FORMAT_CSV => false,
                            ExportMenu::FORMAT_HTML => false,
                            ExportMenu::FORMAT_EXCEL=>false,

                        ]
                    ]);
                    ?>

                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        //  'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                            'branch_name',

                            [
                                'label'=>'Winner(Name-Mobile-Chassis Number)',
                                'format'=>'raw',
                                'value' => function($data){
                                   return $data->winner;
                                }
                            ],

                            [
                                'label'=>'Date',
                                'format'=>'raw',
                                'value' => function($data){
                                    return $data->winner_date;
                                }
                            ],

                            ['class' => 'yii\grid\ActionColumn','template'=>'{update} {delete}','buttons' => [

                                'update' => function ($url, $model) {
                                    return Html::a('<span class="glyphicon glyphicon-pencil"></span>', ['branches/index','id'=>$model->id], [
                                        'title' => Yii::t('app', 'update'),
                                    ]);
                                },

                            ],],
                        ],
                    ]); ?>

                </div>
            </div>
        </div>
    </div>
</section>
<?php
$script = <<< JS
$(document).ready(function() { $('.dropdown-toggle').dropdown(); });
JS;
$this->registerJs($script, View::POS_END);
?>