<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Participants2025 */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Participants', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
    <section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
               
                <!-- /.box-header -->
                
                <div class="box-body pad">
                    <div class="pull-right">
                        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
                    </div>
                <?= DetailView::widget([
                    'model' => $model,
                    'attributes' => [
                    
                        'name',
                        'mobile',
                        'quantity',
                        'status',
                        'created_at',
                        [
                            'attribute' => 'receipt_image',
                            'format' => 'raw',
                            'value' => function ($model) {
                                return Html::img($model->receipt_image, ['width' => '200px']);
                            },
                        ],
                      
                    [
                        'attribute' => 'receipt_image',
                        'format' => 'raw',
                        'value' => function ($model) {
                            return Html::a('View Receipt', $model->receipt_image, ['target' => '_blank']);
                        },
                    ],
                  
                       
                    ],
                ]) ?>
                </div>
            </div>
        </div>
    </div>
    </section>

