<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;
use dosamigos\fileupload\FileUploadUI;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Files */
/* @var $form yii\widgets\ActiveForm */

$this->title = 'Gallery';
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Galleries'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?> (Upload .mp4)</h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">
                    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                    <?= FileUploadUI::widget([
                        'model' => $model,
                        'attribute' => 'image',
                        'url' => ['settings/galleryvideoupload'],
                        'gallery' => false,
                        'load'=>false,


                        'clientOptions' => [
                            'maxFileSize' => 2000000
                        ],


                        'clientEvents' => [
                            'fileuploaddone' => 'function(e, data) {
                             $.pjax.reload({container:"#residencegallery"});

                            }',
                            'fileuploadfail' => 'function(e, data) {

                            }'
                        ],
                    ]); ?>


                    <?php ActiveForm::end(); ?>
                </div>
                <?php yii\widgets\Pjax::begin(['id' => 'residencegallery','timeout' => false, 'enablePushState' => false,'linkSelector' => "a:not('.no-pjax')",]) ?>
                <div class="box-body pad">
                    <div class="row">
                        <?php
                        if($images){
                            foreach($images as $banner){
                                ?>
                                <div class="col-lg-3 col-md-4 col-xs-6 thumb">
                                    <a class="thumbnail" href="#">
                                        <video width="320" height="240" controls>
                                            <source src="<?php echo Yii::$app->urlManagerfrontend->baseUrl.'/uploads/'.$banner->image?>" type="video/mp4">
                                            Your browser does not support the video tag.
                                        </video>

                                    </a>
                                    <div class="text-center">

                                        <?php
                                        $url=Yii::$app->urlManager->createUrl(['settings/imagesingledelete','id'=>$banner->id]);
                                        echo Html::a('<i class="fa fa-trash-o"></i>','', [
                                            'class'=>'btn btn-danger btn-xs',
                                            'onclick'=>"
                            var r = confirm('Are you sure delete this image ?');
                            if (r == true) {

                                $.ajax({
                                type     :'POST',
                                cache    : false,
                                url  : '$url',
                                success  : function(response) {
                                    $.pjax.reload({container:'#residencegallery'});
                                }
                                });return false;   } ",

                                        ]);?>
                                    </div>
                                </div>
                            <?php }}?>
                    </div>
                </div>
                <?php Pjax::end(); ?>
                <!-- /.box -->

            </div>
        </div>
</section>

