<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Consumers;

/**
 * ConsumersSearch represents the model behind the search form of `common\models\Consumers`.
 */
class ConsumersSearch extends Consumers
{
    public  $from;
    public  $to;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'fk_promoter', 'winner'], 'integer'],
            [['from','to','consumer_name', 'invoice', 'civil_id', 'mobile', 'email', 'web_reference', 'created_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Consumers::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'fk_promoter' => $this->fk_promoter,
            'winner' => $this->winner,
        ]);

        $query->andFilterWhere(['like', 'consumer_name', $this->consumer_name])
            ->andFilterWhere(['like', 'invoice', $this->invoice])
            ->andFilterWhere(['like', 'civil_id', $this->civil_id])
            ->andFilterWhere(['like', 'mobile', $this->mobile])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'web_reference', $this->web_reference])
            ->andFilterWhere(['between', 'created_date',$this->from,$this->to ]);
            $query->orderBy([
                'created_date'=>SORT_DESC,
            ]);

        return $dataProvider;
    }
}
