<?php

namespace backend\controllers;

use common\models\Circular;
use common\models\Images;
use common\models\Settingstwo;
use common\models\Transfercertificates;
use backend\models\SignupForm;
use common\models\Settings;
use common\models\Slider;
use common\models\Management;
use common\models\Videos;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\data\ActiveDataProvider;
use backend\models\Passwordreset;
use backend\models\User;
use yii\imagine\Image;
use yii\base\Model;
use yii\helpers\FileHelper;
use yii\helpers\Json;
use yii\helpers\Url;

/**
 * SliderController implements the CRUD actions for Slider model.
 */
class SettingsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /*sort start*/
    public function actionSort()
    {
        return $this->render('sortable', [
        ]);
    }
    
        public function actionPrize()
    {
        $model=Settings::find()->where(['item'=>'prize'])->all();

        if (Model::loadMultiple($model, Yii::$app->request->post()) &&
            Model::validateMultiple($model)) {
            $count = 0;
            foreach ($model as $item) {
                $item->save();
            }
            return $this->redirect(['prize']);
        }
        return $this->render('social', [
            'model'=>$model
        ]);
    }

    public function actionSave()
    {
        $data = json_decode($_POST['data']);

        function parseJsonArray($jsonArray, $parentID = 0) {

            $return = array();
            foreach ($jsonArray as $subArray) {
                $returnSubSubArray = array();
                if (isset($subArray->children)) {
                    $returnSubSubArray = parseJsonArray($subArray->children, $subArray->id);
                }

                $return[] = array('id' => $subArray->id, 'parentID' => $parentID);
                $return = array_merge($return, $returnSubSubArray);
            }
            return $return;
        }

        $readbleArray = parseJsonArray($data);

        $i=0;
        foreach($readbleArray as $row){
            $i++;
            Yii::$app->db->createCommand()
                ->update('cms', ['cms_key' => $row['parentID'],'cms_order'=>$i],['cms_id'=>$row['id']])
                ->execute();
        }
    }

    /*sort end*/

    public function actionType()
    {
        $model=Settings::find()->where(['type'=>'option'])->one();
        $modelTime=Settingstwo::find()->where(['type'=>'time'])->one();

        if ($model->load(Yii::$app->request->post()) && $modelTime->load(Yii::$app->request->post())) {
           $model->save();
            $modelTime->save();
            return $this->redirect(['type']);
        }


        return $this->render('type', [
            'model'=>$model,
            'modelTime'=>$modelTime,
        ]);
    }


    public function actionFooterlinks()
    {
        $model=Settings::find()->where(['type'=>'footermenu'])->orderBy(['sort_order'=>SORT_ASC])->all();

        if (Model::loadMultiple($model, Yii::$app->request->post()) &&
            Model::validateMultiple($model)) {
            $count = 0;
            foreach ($model as $item) {
                $item->save();
            }
            return $this->redirect(['footerlinks']);
        }
        return $this->render('footer', [
            'model'=>$model
        ]);
    }

    public function actionSocialmedia()
    {
        $model=Settings::find()->where(['type'=>'socialmedia'])->all();

        if (Model::loadMultiple($model, Yii::$app->request->post()) &&
            Model::validateMultiple($model)) {
            $count = 0;
            foreach ($model as $item) {
                $item->save();
            }
            return $this->redirect(['socialmedia']);
        }
        return $this->render('social', [
            'model'=>$model
        ]);
    }

    public function actionEmail($type)
    {
        $model=Settings::find()->where(['type'=>$type])->one();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['email','type'=>$type]);
        }
        return $this->render('email', [
            'model'=>$model
        ]);
    }


    public function actionUsers()
    {
        $model=new SignupForm();
        $query=User::find()->where('id<>:cuid',['cuid'=>Yii::$app->user->identity->id]);

        $provider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => 50,
            ],
        ]);

        if ($model->load(Yii::$app->request->post())) {
            $model->username=$model->email;
            if ($user = $model->signup()) {
                return $this->redirect(['users']);
            }
        }
        return $this->render('_form_user', [
            'model'=>$model,
            'provider'=>$provider
        ]);

    }

    public function actionUserupdate($id)
    {
        $model=$this->findModeluser($id);
        $modelResetpassword=$this->findModeluser($id);
        $modelResetpassword->scenario='newpass';

        if ($modelResetpassword->load(Yii::$app->request->post())) {
            if ($modelResetpassword->validate()) {
                if($modelResetpassword->newpass!=null):
                 $modelResetpassword->setPassword($modelResetpassword->newpass);
                    $modelResetpassword->save(false);
                endif;
                return $this->redirect(['users']);
            }
        }

        if ($model->load(Yii::$app->request->post())) {

            if ($model->save(false)) {
                return $this->redirect(['users']);
            }
        }

        return $this->render('_form_user_update', [
            'model'=>$model,
            'modelResetpassword'=>$modelResetpassword
        ]);
    }

    public function actionDeleteuser($id)
    {
        $model=$this->findModeluser($id);
        $model->delete(false);
        return $this->redirect(['users']);
    }

    public function actionAdminupdate($id='')
    {
        $Passwordreset=new Passwordreset();
        $model=new User();

        if($id==null):
            $model= $model->findOne(Yii::$app->user->identity->id);

        else:
            $Passwordreset->userid=$id;

        endif;

        $model->scenario = "update";

        if ($Passwordreset->load(Yii::$app->request->post()))
        {

            $isValid = $Passwordreset->validate();
            if ($isValid) {
                $user = \common\models\User::findOne(Yii::$app->user->identity->id);
                if($Passwordreset->newpass):
                    $user->setPassword($Passwordreset->newpass);
                endif;
                if($user->save()){
                    return $this->redirect(['site/index']);
                }
            }

        }
        return $this->render('admin_form', [
            'Passwordreset' =>$Passwordreset,
            'model'=>$model
        ]);
    }

    public function actionUploadimage()
    {
        $this->enableCsrfValidation = false;
        $time = time();
        $url = Yii::getAlias('@frontend') .'/web/uploads/';

        // $fdata = explode('ckeditor/ckupload.php',$furl);

        //extensive suitability check before doing anything with the file...
        if (($_FILES['upload'] == "none") OR (empty($_FILES['upload']['name'])) )
        {
            $message = "No file uploaded.";
        }
        else if ($_FILES['upload']["size"] == 0)
        {
            $message = "The file is of zero length.";
        }
        else if (($_FILES['upload']["type"] != "application/pdf") AND ($_FILES['upload']["type"] != "image/pjpeg") AND ($_FILES['upload']["type"] != "image/jpeg") AND ($_FILES['upload']["type"] != "image/png"))
        {
            $message = "The image must be in either JPG or PNG format. Please upload a JPG or PNG instead.";
        }
        else if (!is_uploaded_file($_FILES['upload']["tmp_name"]))
        {
            $message = "You may be attempting to hack our server. We're on to you; expect a knock on the door sometime soon.";
        }
        else {
            $message = "";
            $uploadFilename = basename($_FILES['upload']['name']);

            $tempFilename = $_FILES['upload']['tmp_name'];

            $move =move_uploaded_file($tempFilename, $url.$time."_".$uploadFilename);

            if(!$move)
            {
                $message = "Error moving uploaded file. Check the script is granted Read/Write/Modify permissions.";
            }

            $urlname = $time."_".$_FILES['upload']['name'];
            $furl = Yii::$app->urlManagerfrontend->createAbsoluteUrl('/uploads/'.$urlname);
        }

        $CKEditorFuncNum = $_GET['CKEditorFuncNum'] ;

        echo "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum,'$furl', '$message');</script>";

    }

    protected function findModeluser($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
