<?php

namespace common\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Participants2025;

/**
 * Participants2025Search represents the model behind the search form of `common\models\Participants2025`.
 */
class Participants2025Search extends Participants2025
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id'], 'integer'],
            [['email', 'uuid', 'contact', 'country', 'name', 'prizes', 'purchase_receipt', 'user_language', 'date_time', 'source_sheet'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Participants2025::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'  => ['defaultOrder' => ['id' => SORT_DESC]], // newest first
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id'        => $this->id,
            'date_time' => $this->date_time,
        ]);

        $query->andFilterWhere(['like', 'email', $this->email])
              ->andFilterWhere(['like', 'uuid', $this->uuid])
              ->andFilterWhere(['like', 'contact', $this->contact])
              ->andFilterWhere(['like', 'country', $this->country])
              ->andFilterWhere(['like', 'name', $this->name])
              ->andFilterWhere(['like', 'prizes', $this->prizes])
              ->andFilterWhere(['like', 'purchase_receipt', $this->purchase_receipt])
              ->andFilterWhere(['like', 'user_language', $this->user_language])
              ->andFilterWhere(['like', 'source_sheet', $this->source_sheet]);

        return $dataProvider;
    }
}
