<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "prizes".
 *
 * @property int $id
 * @property string $name
 * @property string $quantity
 * @property string $current_qty
 */
class Prizes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'prizes';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'string', 'max' => 250],
            [['quantity', 'current_qty'], 'string', 'max' => 50],
            [['draw_status'], 'safe']
            
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Prize Name',
            'quantity' => 'Quantity',
            'current_qty' => 'Current Qty',
        ];
    }
}
