<?php 
include ('common/header.php');
require "common/Queries.php";

$q = new Queries();
$banners = $q->getBanners();
$partnersTitle = $q->getModule("bannerTitle");
$products = $q->getHomeProducts();
$imageServerPath = $q->imageServerPath();
$news = $q->getNews();
?>
<section class="hero-sec">
    <div class="hero-cover position-relative">
      <div class="swiper swiper-hero position-relative">
         <div class="overlay">
            <div class="container">
              <div class="d-flex align-items-center">
                 <div class="flex-grow-1 pe-3"> <hr class="opacity-50"/></div>
                 <div class="flex-fixed slider-nav">
                  <div class="swiper-button-prev" tabindex="0" role="button" aria-label="Previous slide" aria-controls="swiper-wrapper-4b768511a4e19dd3">
                  <img src="images/arrow-left-wt.png" alt="Icon">
                </div>
                <div class="swiper-button-next" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper-4b768511a4e19dd3">
                  <img src="images/arro-right-wt.png" alt="Icon">
                </div>
                 </div>
              </div>              
              <div class="row pb-4 pb-lg-5">
                <div class="col-lg-6">
                  <div class="display-3 fw-bold" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
                    <?= str_replace('|', '<br />', htmlspecialchars($partnersTitle['name'])); ?>
                   
                  </div>
                 <div class="d-none d-md-block" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">  <?= str_replace('|', '<br />', htmlspecialchars($partnersTitle['sub_title'])); ?></div>
                </div>
              </div>
              <a href="<?=$partnersTitle['description']?>" class="btn btn-primary px-4 px-lg-5 py-2 rounded-3" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">Get Started</a>
            </div>
          </div>
        <div class="swiper-wrapper" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
         <?php  foreach ($banners as $row): ?>
          <?php if($row['video']!=''){?>
            <div class="swiper-slide">
              <div class="hero-slider">
                <video
                  autoplay
                  loop
                  muted
                  playsinline
                  poster="<?= htmlspecialchars($row['image']); ?>"
                >
                  <source src="<?= htmlspecialchars($row['video']); ?>" type="video/mp4" />
                </video>
              </div>
            </div>   
          <?php }else{?> 
            <div class="swiper-slide">
              <div class="hero-slider">
                <img src="<?= htmlspecialchars($row['image']); ?>" alt="Slider" class="object-fit-cover w-100" />
              </div>
            </div>
          <?php }?>
        
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </section>

  <section class="services-sec px-xl-150px px-lg-100px pt-40px pb-40px pt-lg-72px pb-lg-72px">
      <div class="container-fluid">
          <div class="row">

              <?php
              $classes = ['service-100', 'service-200', 'service-300', 'service-400'];
              $delay = 250;
              $duration = 1000;

              foreach ($products as $index => $item) {
                  $class = $classes[$index % 4];
                  $duration = 1000 + ($index * 200); 
              ?>
                  <div class="col-12 col-md-6 col-lg-3"
                      data-aos="fade-up"
                      data-aos-delay="<?= $delay ?>"
                      data-aos-duration="<?= $duration ?>">

                      <div class="services-item <?= $class ?>">
                          <div class="service-head">
                              <div class="service-title">
                                  <h3><?= $item['name'] ?></h3>
                                  <h5><?= $item['sub_title'] ?></h5>
                              </div>
                              <div class="service-icon">
                                  <img src="<?= $item['image_ar'] ?>" alt="Icon" />
                              </div>
                          </div>

                          <div class="service-pic">
                              <img src="<?=$imageServerPath.$item['image'] ?>"/>
                          </div>

                          <div class="service-body">
                              <ul>
                                  <?= nl2br($item['description']) ?>
                              </ul>
                          </div>

                          <div class="service-footer">
                              <a class="btn btn-more" href="<?= $item['description4'] ?>">
                                  <img src="images/arro-right-wt.png" alt="" />
                              </a>
                          </div>
                      </div>
                  </div>
              <?php } ?>

          </div>
      </div>
  </section>


  <section class="choose-sec pt-40px pb-40px pt-lg-72px pb-lg-72px">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="section-hd">
            <h3 class="fw-bolder display-6" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">Why Choose CloudAcropolis?</h3>
            <h5 data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">What makes our services so unique.</h5>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1000">
          <div class="choose-item choose-100">
            <div class="choose-nav">
              <a class="btn btn-more" href="javascript:;"><img src="images/arro-right-dk.png" alt="Icon" /></a>
            </div>
            <div class="choose-bod">
              <div class="choose-hd">
                <h3>
                  Local <br />
                  Setup
                </h3>
                <p>
                  Cloud Acropolis is an international Service provider having
                  base in Oman and in Europe.
                </p>
              </div>
            </div>
            <div class="choose-pic">
              <div class="choose-icon">
                <img src="images/choose-pic-01.png" alt="Picture" />
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1200">
          <div class="choose-item choose-200">
            <div class="choose-pic">
              <div class="choose-icon">
                <img src="images/choose-pic-02.png" alt="Picture" />
              </div>
            </div>
            <div class="choose-bod">
              <div class="choose-hd">
                <h3>
                  Highly <br />
                  Available
                </h3>
                <p>
                  Cloud Acropolis entire setup always follow a fully redundant
                  and fault tolerant architecture.
                </p>
              </div>
            </div>
            <div class="choose-nav">
              <a class="btn btn-more" href="javascript:;"><img src="images/arro-right-dk.png" alt="Icon" /></a>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1400">
          <div class="choose-item choose-300">
            <div class="choose-nav">
              <a class="btn btn-more" href="javascript:;"><img src="images/arro-right-dk.png" alt="Icon" /></a>
            </div>
            <div class="choose-bod">
              <div class="choose-hd">
                <h3>
                  Telecom <br />
                  Independent
                </h3>
                <p>
                  Cloud Acropolis entire setup always follow a fully redundant
                  and fault tolerant architecture.
                </p>
              </div>
            </div>
            <div class="choose-pic">
              <div class="choose-icon">
                <img src="images/choose-pic-03.png" alt="Picture" />
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1600">
          <div class="choose-item choose-400">
            <div class="choose-nav">
              <a class="btn btn-more" href="javascript:;"><img src="images/arro-right-dk.png" alt="Icon" /></a>
            </div>
            <div class="choose-bod">
              <div class="choose-hd">
                <h3>
                  Outstanding <br />
                  Tier 4 Service
                </h3>
                <p>
                  We are committed to bring the best Cloud experience to its
                  customers.
                </p>
              </div>
            </div>
            <div class="choose-pic">
              <div class="choose-icon">
                <img src="images/choose-pic-04.png" alt="Picture" />
              </div>
            </div>
          </div>
        </div>
        <div class="col-12 col-lg-8" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1800">
          <div class="choose-item choose-500">
            <div class="choose-pic">
              <div class="choose-icon">
                <img src="images/choose-pic-05.png" alt="Picture" />
              </div>
            </div>
            <div class="choose-bod">
              <div class="choose-hd">
                <h3>Complimentary Go to Cloud Consultancy</h3>
                <p>
                  In the age of Cloud computing ,we help our customers to
                  write their cloud strategy to start with and then will help
                  them to move their IT to the cloud while achieving better
                  performance.
                </p>
              </div>
            </div>
            <div class="choose-nav">
              <a class="btn btn-more" href="javascript:;"><img src="images/arro-right-dk.png" alt="Icon" /></a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section class="testi-sec pt-40px pb-40px pt-lg-72px pb-lg-72px">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="test-hd-cover">
            <div class="section-hd">
              <h3 class="fw-bolder display-6" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">They succeeded online - now it’s your turn</h3>
              <h5 data-aos="fade-up" data-aos-delay="250" data-aos-duration="1700">View our testimonials.</h5>
            </div>
            <div class="testi-profiles">
              <div class="pro-item" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
                <img src="images/testi-profiles.png" alt="Image" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="container-fluid px-4 px-md-0">
      <div class="row mx-0">
        <div class="col-12 px-0" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
          <div class="testi-slider">
            <div class="swiper swiper-testi">
              <div class="swiper-wrapper">
                <div class="swiper-slide">
                  <div class="testi-item">
                    <div class="testi-pic">
                      <img src="images/testi-pic-01.jpg" alt="Image" />
                    </div>
                    <div class="testi-bod">
                      <div class="testi-logo">
                        <img src="images/testi-logo-01.png" alt="Logo" />
                      </div>
                      <p>
                        “Cloud Acropolis helped us to find the perfect
                        solution for our hosting needs.
                      </p>
                      <p>
                        Their team of expert helped us move all our
                        information very fast and till now our services have
                        been 100% stable."
                      </p>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="testi-item">
                    <div class="testi-pic">
                      <img src="images/testi-pic-02.jpg" alt="Image" />
                    </div>
                    <div class="testi-bod">
                      <div class="testi-logo">
                        <img src="images/testi-logo-01.png" alt="Logo" />
                      </div>
                      <p>
                        “Cloud Acropolis helped us to find the perfect
                        solution for our hosting needs.
                      </p>
                      <p>
                        Their team of expert helped us move all our
                        information very fast and till now our services have
                        been 100% stable."
                      </p>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="testi-item">
                    <div class="testi-pic">
                      <img src="images/testi-pic-01.jpg" alt="Image" />
                    </div>
                    <div class="testi-bod">
                      <div class="testi-logo">
                        <img src="images/testi-logo-01.png" alt="Logo" />
                      </div>
                      <p>
                        “Cloud Acropolis helped us to find the perfect
                        solution for our hosting needs.
                      </p>
                      <p>
                        Their team of expert helped us move all our
                        information very fast and till now our services have
                        been 100% stable."
                      </p>
                    </div>
                  </div>
                </div>
                <div class="swiper-slide">
                  <div class="testi-item">
                    <div class="testi-pic">
                      <img src="images/testi-pic-02.jpg" alt="Image" />
                    </div>
                    <div class="testi-bod">
                      <div class="testi-logo">
                        <img src="images/testi-logo-02.png" alt="Logo" />
                      </div>
                      <p>
                        “Cloud Acropolis helped us to find the perfect
                        solution for our hosting needs.
                      </p>
                      <p>
                        Their team of expert helped us move all our
                        information very fast and till now our services have
                        been 100% stable."
                      </p>
                    </div>
                  </div>
                </div>
              </div>
              <div class="testi-slider-nav">
                <div class="testi-swiper-button-prev">
                  <img src="images/arrow-left-wt.png" alt="Icon" />
                </div>
                <div class="testi-swiper-button-next">
                  <img src="images/arro-right-wt.png" alt="Icon" />
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

<?php
$typeBg = [
    'Featured'       => 'bg-100',
    'Certification'  => 'bg-600',
    'Infrastructure' => 'bg-700',
];
?>

<section class="news-sec">
  <div class="container">
    <h2 class="fw-bolder display-6" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
      Latest Events & News
    </h2>
    <p class="mb-4 mb-lg-5" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
      Stay updated with Cloud Acropolis announcements and achievements
    </p>

    <div class="row">
      <div class="col-12" data-aos="fade-up" data-aos-delay="250" data-aos-duration="1500">
        <div class="swiper swiper-news">
          <div class="swiper-wrapper">

            <?php foreach ($news as $item): ?>
              <?php
                // safe fields
                $title = htmlspecialchars($item['name'] ?? '', ENT_QUOTES, 'UTF-8');
                $desc  =$item['description'];
                //$slug  = urlencode($item['slug'] ?? '');
                $type  = $item['type'] ?? '';
                $img   = !empty($item['image']) ? $item['image'] : 'images/placeholder-news.jpg';

                // label class from type
                $labelClass = $typeBg[$type] ?? 'bg-100';
              ?>
              <div class="swiper-slide">
                <div class="news-item">
                  <div class="news-label <?= $labelClass; ?>"><?= htmlspecialchars($type, ENT_QUOTES, 'UTF-8'); ?></div>

                  <div class="news-pic">
                    <img src="<?=$imageServerPath. $img; ?>" alt="News" />
                  </div>

                  <div class="news-body">
                    <div class="news-hd">
                      <h3 class="fw-bold"><?= $title; ?></h3>
                     
                    </div>
                    <p><?= $desc; ?></p>
                  </div>

                  <div class="news-footer">
                    <a class="btn btn-more" href="#">
                      <img src="images/arro-right-dk.png" alt="Icon" />
                    </a>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
          <!-- Optional: add pagination/nav if you use them in your theme -->
          <!-- <div class="swiper-pagination"></div> -->
          <!-- <div class="swiper-button-next"></div> -->
          <!-- <div class="swiper-button-prev"></div> -->
        </div>
      </div>
    </div>
  </div>
</section>

  <?php include ('common/footer.php');?>