<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use dosamigos\ckeditor\CKEditor;

$this->title = 'Footer Menu';

$this->params['breadcrumbs'][] = $this->title;
?>

<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><?=$this->title?></h3>
                </div>

    <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
        <div class="box-body">
            <?php foreach($model as $i=>$item){ ?>
            <strong><?=$item->title?></strong>

            <?php if($item->item=='footermenu'){?>
                    <?= $form->field($item,"[$i]value")->widget(CKEditor::className(), [
                        'preset' => 'full',
                        'clientOptions' => [
                            'height' => 100,
                            'allowedContent' => true,

                            'filebrowserUploadUrl' => Yii::$app->urlManager->createUrl(['cms/uploadimage']),

                        ]
                    ])->label(false) ?>
            <?php }else{?>
                    <?= $form->field($item,"[$i]value")->widget(CKEditor::className(), [
                        'preset' => 'full',
                        'clientOptions' => [
                            'height' => 100,
                            'allowedContent' => true,
                            'ContentLangDirection'=>'rtl',
                            'filebrowserUploadUrl' => Yii::$app->urlManager->createUrl(['cms/uploadimage']),
                            'language'=>'ar',
                            'extraPlugins'=>'iframe'
                        ]
                    ])->label(false); ?>
            <?php }?>

            <?php } ?>

            <div class="form-group">
                <?= Html::submitButton('Save', ['class' =>'btn btn-success']) ?>
            </div>
        </div>
    <?php ActiveForm::end(); ?>

</div>
            </div>
        </div>
    </section>
