$(document).ready(function () {
  // Loader
  $(window).on("load", function () {
    $(".loader-overlay").delay(2000).fadeOut("slow");
  });

  // Fixed navbar
  $(window).scroll(function () {
    var sticky = $(".navbar-main"),
      scroll = $(window).scrollTop();

    if (scroll >= 100) sticky.addClass("navbar-fixed");
    else sticky.removeClass("navbar-fixed");
  });

  // ===== Scroll to Top ====
  $(window).scroll(function () {
    if ($(this).scrollTop() >= 50) {
      // If page is scrolled more than 50px
      $("#return-top").fadeIn(200); // Fade in the arrow
    } else {
      $("#return-top").fadeOut(200); // Else fade out the arrow
    }
  });

  // Return to top
  $("#return-top").click(function () {
    // When arrow is clicked
    $("body,html").animate(
      {
        scrollTop: 0, // Scroll to top of body
      },
      500
    );
  });

  //jQuery for page scrolling feature - requires jQuery Easing plugin
  $(function () {
    $("a.page-scroll").bind("click", function (event) {
      var $anchor = $(this);
      $("html, body")
        .stop()
        .animate(
          {
            scrollTop: $($anchor.attr("href")).offset().top,
          },
          1500,
          "easeInOutExpo"
        );
      event.preventDefault();
    });
  });

  // Custom Input File

  var inputs = document.querySelectorAll(".upload-doc");

  for (var i = 0, len = inputs.length; i < len; i++) {
    customInput(inputs[i]);
  }

  function customInput(el) {
    const fileInput = el.querySelector('[type="file"]');
    const label = el.querySelector("[data-js-label]");

    fileInput.onchange = fileInput.onmouseout = function () {
      if (!fileInput.value) return;

      var value = fileInput.value.replace(/^.*[\\\/]/, "");
      el.className += " chosen";
      label.innerText = value;
    };
  }

  //--------------------- end of document ready
});
