<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "consumers".
 *
 * @property int $id
 * @property int $fk_promoter
 * @property string $consumer_name
 * @property string $invoice
 * @property string $civil_id
 * @property string $mobile
 * @property string $email
 * @property string $web_reference
 * @property string $created_date
 */
class Consumers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'consumers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fk_promoter'], 'integer'],
            [['created_date','winner'], 'safe'],
            [['email'], 'email'],
             ['invoice_number', 'unique', 'targetClass' => '\common\models\Consumers', 'message' => 'This invoice number has already exist.'],
            ['mobile', 'match', 'pattern' => '/^(7?9?[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9])$/', 'message' => 'Invalid phone number'],
            [['consumer_name', 'invoice', 'civil_id', 'mobile', 'email', 'web_reference','invoice_number'], 'safe'],
            [['consumer_name', 'invoice', 'civil_id', 'mobile', 'email', 'web_reference','invoice_number'], 'required'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fk_promoter' => 'Fk Promoter',
            'consumer_name' => 'Consumer Name',
            'invoice' => 'Invoice Image',
            'civil_id' => 'Civil ID',
            'mobile' => 'Mobile',
            'email' => 'Email',
            'web_reference' => 'Web Reference',
            'created_date' => 'Created Date',
        ];
    }

    public function Sendmail($model){
        $message = Yii::$app
            ->mailer
            ->compose('layouts/registration', ['model' => $model]
            )
            ->setFrom(['adventzomantest@gmail.com' => 'Lucky Draw Registration'])
            ->setTo([$model->email])
            ->setSubject('Lucky Draw Registration');
        $message->send();
    }
    public function getPromoters()
    {
        return $this->hasOne(User::className(), ['id' => 'fk_promoter']);
    }

}
