<?php

use yii\helpers\Html;
use yii\grid\GridView;
use kartik\export\ExportMenu;

/* @var $this yii\web\View */
/* @var $searchModel common\models\ConsumersSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Consumers';
$this->params['breadcrumbs'][] = $this->title;
?>
    <section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
               
                <!-- /.box-header -->
                <div class="box-body pad">
                <?php echo $this->render('_search', ['model' => $searchModel]); ?>
                </div>
                <div class="box-body pad">


<?php   
$gridColumns = [
['class' => 'yii\grid\SerialColumn'],
[
    'label'=>'Promotor Name',
    'value'=>function ($model, $key, $index, $widget) {
      return $model->promoters->name;
    },
    'format'=>'html'
],
'web_reference',
'consumer_name',
'civil_id',
'mobile',
'email:email',
'invoice_number',

[
    'label'=>'Invoice',
    'value'=>function ($model, $key, $index, $widget) {
        $url='https://medcoman.com/uploads/'.$model->invoice;
        return $url;
    },
    'format'=>'html'
],
'created_date',
];
echo  ExportMenu::widget([
    'dataProvider' => $dataProvider,
    'columns' => $gridColumns,
    'target' => ExportMenu::TARGET_BLANK,
    'columnSelectorOptions'=>[
        'label' => 'Columns',
    ],
    'fontAwesome' => true,
    'dropdownOptions' => [
        'label' => 'Export To Excel',
    ],
    'exportConfig' => [
        ExportMenu::FORMAT_TEXT => false,
        ExportMenu::FORMAT_PDF => false,
        ExportMenu::FORMAT_CSV => false,
        ExportMenu::FORMAT_HTML => false,
        ExportMenu::FORMAT_EXCEL=>false,
    ]
]); ?>


    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            [
                'label'=>'Promotor Name',
                'value'=>function ($model, $key, $index, $widget) {
                  return $model->promoters->name;
                },
                'format'=>'html'
            ],
            'web_reference',
            'consumer_name',
            'civil_id',
            'mobile',
            'email:email',
            'invoice_number',
            
            [
                'label'=>'Invoice',
                'value'=>function ($model, $key, $index, $widget) {
                    $url= Yii::$app->urlManagerfrontend->createAbsoluteUrl('/frontend/web/uploads/'.$model->invoice);
                    return '<a href="'.$url.'" >View</a>';
                },
                'format'=>'html'
            ],
            'created_date',
            //['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
  </div>
        </div>
    </div>
</section>

