<?php

/* @var $this \yii\web\View */
/* @var $content string */

use backend\assets\AppAsset;
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use common\widgets\Alert;
use mdm\admin\components\Helper;

$asset=AppAsset::register($this);
$baseUrl=    $asset->baseUrl;
?>
<?php $this->beginPage();?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body class="hold-transition skin-green sidebar-mini">
<?php $this->beginBody() ?>
<div class="wrapper">
    <header class="main-header">

        <!-- Logo -->
        <a href="<?=Yii::$app->urlManager->createUrl(['site/index'])?>" class="logo">
            <!-- mini logo for sidebar mini 50x50 pixels -->
            <span class="logo-mini">Lucky Draw</span>
            <!-- logo for regular state and mobile devices -->
            <span class="logo-lg">Lucky Draw</span>
        </a>

        <!-- Header Navbar: style can be found in header.less -->
        <nav class="navbar navbar-static-top">
            <!-- Sidebar toggle button-->
            <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
                <span class="sr-only">Toggle navigation</span>
            </a>
            <!-- Navbar Right Menu -->
            <div class="navbar-custom-menu">
                <ul class="nav navbar-nav">
                    <!-- User Account: style can be found in dropdown.less -->
                    <li class="dropdown user user-menu">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <img src="<?php echo $baseUrl ?>/css/dist/img/user2-160x160.jpg" class="user-image" alt="User Image">
                            <span class="hidden-xs"><?=Yii::$app->user->identity->username?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <!-- User image -->
                            <li class="user-header">
                             <img src="<?php echo $baseUrl ?>/css/dist/img/user2-160x160.jpg" class="img-circle" alt="User Image">

                                <p>
                                    <?=Yii::$app->user->identity->username ?>

                                </p>
                            </li>
                            <!-- Menu Body -->
                           <!-- <li class="user-body">
                                <div class="row">
                                    <div class="col-xs-4 text-center">
                                        <a href="#">Followers</a>
                                    </div>
                                    <div class="col-xs-4 text-center">
                                        <a href="#">Sales</a>
                                    </div>
                                    <div class="col-xs-4 text-center">
                                        <a href="#">Friends</a>
                                    </div>
                                </div>
                                <!-- /.row -->
                           <!-- </li>-->
                            <!-- Menu Footer-->
                            <li class="user-footer">
                                <div class="pull-left">
                                    <a href="<?=Yii::$app->urlManager->createUrl(['settings/adminupdate'])?>" class="btn btn-default btn-flat">Profile</a>
                                </div>
                                <div class="pull-right">
                                    <a href="<?=Yii::$app->urlManager->createUrl(['site/logout'])?>" data-method="post" class="btn btn-default btn-flat">Sign out</a>

                                </div>
                            </li>
                        </ul>
                    </li>


                </ul>
            </div>

        </nav>
    </header>

    <!-- Left side column. contains the logo and sidebar -->
    <aside class="main-sidebar">
        <!-- sidebar: style can be found in sidebar.less -->
        <section class="sidebar">
            <?php
          $menuItems = [
             
           ['label' => 'Winners', 'icon' => 'fa fa-file-text-o', 'url' => ['/winner2021/index']],
            ['label' => 'Participants', 'icon' => 'fa fa-file-text-o', 'url' => ['/participants2025/index']],
            
             ['label' => 'Settings', 'icon' => 'fa fa-file-text-o', 'url' => ['/settings/prize']],
            ];
           
            //$menuItems = Helper::filter($menuItems);
            ?>
            <?= common\components\Menu::widget(
                [
                    'options' => ['class' => 'sidebar-menu'],
                    'items' => $menuItems,
                ]
            ) ?>
            <?php
           /* if(Yii::$app->user->identity->type=='admin'){
                echo    common\components\Menu::widget(
                    [
                        'options' => ['class' => 'sidebar-menu'],
                        'items' => [

                            [
                                'label' => 'Add & Manage Promoters',
                                'icon' => 'fa fa-user',
                                'url' => '#',
                                'items' => [
                                    ['label' => 'Add & Manage Promoters', 'icon' => 'fa fa-circle-o', 'url' =>['/settings/users']],
                                    //['label' => 'Assignment', 'icon' => 'fa fa-circle-o', 'url' =>['/admin/assignment']],
                                    //['label' => 'Routes', 'icon' => 'fa fa-circle-o', 'url' =>['/admin/route']],
                                    //['label' => 'Permissions', 'icon' => 'fa fa-circle-o', 'url' =>['/admin/permission']],
                                    //['label' => 'Role', 'icon' => 'fa fa-circle-o', 'url' =>['/admin/role']],
                                ],
                            ],
                           
                        ],
                    ]
                ) ;}*/?>

            <!-- Sidebar user panel -->
            <!-- sidebar menu: : style can be found in sidebar.less -->
        </section>
        <!-- /.sidebar -->
    </aside>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <?php echo $this->title;?>
            </h1>
            <?= Breadcrumbs::widget([
                'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
            ]) ?>
        </section>
    <?= $content ?>
</div>
    <footer class="main-footer">
        <div class="pull-right hidden-xs">

        </div>
        
    </footer>

</div>
<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>


