<?php

use yii\helpers\Html;
use yii\web\View;
?>
<!-- Main content -->
<section class="content">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- general form elements -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Menu (Drag and Arrange Menu)</h3>
                    <div class="pull-right box-tools">
                        <?php //Html::a('<i class="fa fa-plus"></i> Add New ', ['create'], ['class' => 'btn btn-success']) ?>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body pad">

<div id="load"></div>

<input type="hidden" id="id">


<div class="cf nestable-lists">

    <div class="dd" id="nestable">

        <?php
        //$menus=\common\models\Menu::find()->orderBy(['sort'=>SORT_ASC])->all();
        $menus=\common\models\Cms::find()->where(['status'=>1,'cms_type'=>'pages','show_mainmenu'=>1])->orderBy([
            'cms_order'=>SORT_ASC,
        ])->all();
        $ref   = [];
        $items = [];

        foreach($menus as $menu){

            $thisRef = &$ref[$menu->cms_id];
            $thisRef['parent'] = $menu->cms_key;
            $thisRef['label'] = strtoupper($menu->menu_title);
            $thisRef['id'] = $menu->cms_id;

            if($menu->cms_key == 0) {
                $items[$menu->cms_id] = &$thisRef;
            } else {
                $ref[$menu->cms_key]['child'][$menu->cms_id] = &$thisRef;
            }

        }

        function get_menu($items,$class = 'dd-list') {

            $html = "<ol class=\"".$class."\" id=\"menu-id\">";

            foreach($items as $key=>$value) {
                $html.= '<li class="dd-item dd3-item" data-id="'.$value['id'].'" >
                    <div class="dd-handle dd3-handle"></div>
                    <div class="dd3-content"><span id="label_show'.$value['id'].'">'.$value['label'].'</span>

                    </div>';
                if(array_key_exists('child',$value)) {
                    $html .= get_menu($value['child'],'child');
                }
                $html .= "</li>";
            }
            $html .= "</ol>";

            return $html;

        }
        print get_menu($items);
    ?>

    </div>



</div>

<input type="hidden" id="nestable-output">
<!--<button id="save" class="btn btn-danger">Save</button>-->


</div>
        </div>
    </div>
</div>
</section>

<?php
$script = <<< JS
$(document).ready(function()
{

    var updateOutput = function(e)
    {
        var list   = e.length ? e : $(e.target),
            output = list.data('output');
        if (window.JSON) {
            output.val(window.JSON.stringify(list.nestable('serialize')));//, null, 2));
        } else {
            output.val('JSON browser support required for this demo.');
        }
    };

    // activate Nestable for list 1
    $('#nestable').nestable({
        group: 1
    })
    .on('change', updateOutput);



    // output initial serialised data
    updateOutput($('#nestable').data('output', $('#nestable-output')));

    $('#nestable-menu').on('click', function(e)
    {
        var target = $(e.target),
            action = target.data('action');
        if (action === 'expand-all') {
            $('.dd').nestable('expandAll');
        }
        if (action === 'collapse-all') {
            $('.dd').nestable('collapseAll');
        }
    });


});
JS;
$this->registerJs($script, View::POS_END);
?>

<?php
$saveUrl=Yii::$app->urlManager->createUrl(['settings/save']);
$script = <<< JS
 $(document).ready(function(){
    $("#load").hide();

    $('.dd').on('change', function() {
        $("#load").show();

          var dataString = {
              data : $("#nestable-output").val(),
            };

        $.ajax({
            type: "POST",
            url: "$saveUrl",
            data: dataString,
            cache : false,
            success: function(data){
              $("#load").hide();
            } ,error: function(xhr, status, error) {
              alert(error);
            },
        });
    });

    $("#save").click(function(){
         $("#load").show();

          var dataString = {
              data : $("#nestable-output").val(),
            };

        $.ajax({
            type: "POST",
            url: "save.php",
            data: dataString,
            cache : false,
            success: function(data){
              $("#load").hide();
              alert('Data has been saved');

            } ,error: function(xhr, status, error) {
              alert(error);
            },
        });
    });

  });
JS;
$this->registerJs($script, View::POS_END);

$this->registerCssFile("@web/css/sortable/style.css", [
    'depends' => [\yii\bootstrap\BootstrapAsset::className()],
]);
$this->registerJsFile(
    '@web/css/sortable/jquery.nestable.js',
    ['depends' => [\yii\web\JqueryAsset::className()]]
);
?>
